unit CompRect;

interface

uses Classes, Forms, Graphics, Windows,
     Face;

type
  tRectangle = class(tDrawComponent)
  private
  public
    constructor CreateBy(aOwner: tComponent); override;
    constructor CreateByPoint(aOwner: tComponent; aPoint: tPoint); override;
    function GetRgn: hRgn; override;
    procedure Paint; override;
  end;

var dciRectangle: Integer;

implementation

uses Dialogs, SysUtils;

constructor tRectangle.CreateBy(aOwner: tComponent);
begin
  ImageIndex:= 12;
  inherited CreateByBasicName(aOwner, 'Rectangle');
  Color:= clMoneyGreen;
  CreatingByAddPoint:= True;
end;

constructor tRectangle.CreateByPoint(aOwner: tComponent; aPoint: Windows.tPoint);
begin
  CreateBy(aOwner);
  Left:= aPoint.X;
  Top:= aPoint.Y;
end;

function tRectangle.GetRgn: hRgn;
begin
    Result:= CreateRectRgn(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top* DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
end;

procedure tRectangle.Paint;
begin
  with DrawFace.Canvas do
  begin
    Brush.Color:= Color;
    Brush.Style:= bsSolid;
    Pen.Width:= Round(DrawFace.ZoomFactor* LineWidth);
    if Pen.Width< 1 then Pen.Width:= 1;
    if DrawFace.Printing then Pen.Color:= clBlack
                          else Pen.Color:= LineColor;
    Rectangle(Round(Left* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round(Top * DrawFace.ZoomFactor)- DrawFace.Shift.Y,
            Round((Left+ Width)* DrawFace.ZoomFactor)- DrawFace.Shift.X,
            Round((Top+ Height)* DrawFace.ZoomFactor)- DrawFace.Shift.Y);
  end;
  inherited;
end;

initialization

  //dci -> DrawComponentIndex

  dciRectangle:= DrawCompItemList.Add(tDrawCompItem.Create('Rectangle', tRectangle));

end.
